<?php

namespace App\Exports;

use App\Models\DiamondProduct;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class DiamondProductExport implements FromCollection, WithHeadings
{
    protected $userId;

    public function __construct($userId)
    {
        $this->userId = $userId;
    }

    public function collection()
    {
        return DiamondProduct::where('user_id', $this->userId)
            ->get([
                 'stock_id', 'availability', 'shape', 'weight', 'color', 
                'clarity', 'cut_grade', 'grade', 'cut', 'polish', 'symmetry', 'fluorescence_int',
                'fluorescence_color', 'measurements', 'm_length', 'm_width', 'm_depth', 'lab', 
                'treatment', 'is_fancy', 'fancy_color', 'fancy_color_intensity', 'fancy_color_overtone', 
                'depth', 'table_d', 'girdle_thin', 'girdle_thick', 'girdle_perct', 'girdle_con', 
                'culet_size', 'culet_con', 'crown_ht', 'crown_angle', 'pavillion_depth', 'pavillion_angle',
                'laser_inscription', 'cert_comments', 'country', 'state', 'city', 'origin', 'keytosymb',
                'shade', 'star_len', 'report_dt', 'report_type', 'milky', 'eye_clean', 'gemprint_ID', 
                'BGM', 'ratio', 'diamond_type', 'member_comment', 'time_to_location', 'LsMatchedPairSeparable', 
                'pair_stock', 'allow_raplink_feed', 'parcel_stones', 'center_inclusion', 'black_inclusion',
                'lab_location', 'brand', 'Sarine_Name', 'Internal_Clarity_Desc_Code', 'Clarity_Description', 
                'Modified_Rate', 'wire_discount_price', 'diamond_image', 'diamond_image_2', 'diamond_image_3', 
                'diamond_image_4', 'diamond_image_5', 'diamond_image_6', 'diamond_video', 'Video_HTML', 
                'CertificateLink', 'Rap_Price', 'Memo_Price', 'Memo_Discount_PER', 'Buy_Price', 
                'Buy_Price_Discount_PER', 'COD_Buy_Price', 'COD_Buy_Price_Discount_PER', 'price_per_carat', 
                'Certificate', 'cash_price', 'report_filename', 'rapnet', 'rapnet_discount', 'featured', 
                'table_open', 'crown_open', 'girdle_open', 'luster', 'type', 'tinge', 'location_of_black', 
                'table_inclusion', 'surface_graining', 'internal_graining', 'inclusion_pattern', 
                'diamond_origin_report', 'short_title', 'growth_type', 'H&A', 'share_access', 'is_upload', 
                'is_update', 'product_id', 'vendor_id', 'vendor_name', 'feed_type', 'created_at', 'edited_at', 
                'description'
            ]);
    }

    public function headings(): array
    {
        return [
             'stock_id', 'availability', 'shape', 'weight', 'color', 
            'clarity', 'cut_grade', 'grade', 'cut', 'polish', 'symmetry', 'fluorescence_int', 
            'fluorescence_color', 'measurements', 'm_length', 'm_width', 'm_depth', 'lab', 'treatment',
            'is_fancy', 'fancy_color', 'fancy_color_intensity', 'fancy_color_overtone', 'depth',
            'table_d', 'girdle_thin', 'girdle_thick', 'girdle_perct', 'girdle_con', 'culet_size',
            'culet_con', 'crown_ht', 'crown_angle', 'pavillion_depth', 'pavillion_angle', 'laser_inscription',
            'cert_comments', 'country', 'state', 'city', 'origin', 'keytosymb', 'shade', 'star_len',
            'report_dt', 'report_type', 'milky', 'eye_clean', 'gemprint_ID', 'BGM', 'ratio', 'diamond_type',
            'member_comment', 'time_to_location', 'LsMatchedPairSeparable', 'pair_stock', 'allow_raplink_feed',
            'parcel_stones', 'center_inclusion', 'black_inclusion', 'lab_location', 'brand', 'Sarine_Name',
            'Internal_Clarity_Desc_Code', 'Clarity_Description', 'Modified_Rate', 'wire_discount_price',
            'diamond_image', 'diamond_image_2', 'diamond_image_3', 'diamond_image_4', 'diamond_image_5',
            'diamond_image_6', 'diamond_video', 'Video_HTML', 'CertificateLink', 'Rap_Price', 'Memo_Price',
            'Memo_Discount_PER', 'Buy_Price', 'Buy_Price_Discount_PER', 'COD_Buy_Price', 'COD_Buy_Price_Discount_PER',
            'price_per_carat', 'Certificate', 'cash_price', 'report_filename', 'rapnet', 'rapnet_discount', 
            'featured', 'table_open', 'crown_open', 'girdle_open', 'luster', 'type', 'tinge', 'location_of_black', 
            'table_inclusion', 'surface_graining', 'internal_graining', 'inclusion_pattern', 'diamond_origin_report',
            'short_title', 'growth_type', 'H&A', 'share_access', 'is_upload', 'is_update', 'product_id', 'vendor_id',
            'vendor_name', 'feed_type', 'created_at', 'edited_at', 'description'
        ];
    }
}

