<?php

namespace App\Http\Controllers;

use App\Exports\DiamondProductExport;
use App\Imports\DiamondProductImport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use App\Models\DiamondProduct;
use App\Exports\DiamondProductsampleExport;
class DiamondProductController extends Controller
{
    // Export Diamonds
    public function export($userId)
    {
        return Excel::download(new DiamondProductExport($userId), 'diamond_products.csv');
    }
     public function exportsample($userId)
    {
        return Excel::download(new DiamondProductsampleExport($userId), 'diamond_sample.csv');
    }

    // Import Diamonds
      public function import(Request $request)
    {
        // Validate the uploaded file and ensure user_id is present
        $request->validate([
            'file' => 'required|file|mimes:csv,txt',
           
        ]);

        // Get user_id from the form
        $userId = $request->input('user_id');

        // Import the file
        Excel::import(new DiamondProductImport($userId), $request->file('file'));

        return back()->with('success', 'Diamonds imported successfully!');
    }
  public function downloadSampleCSV()
    {
        // Path to the file inside the public folder
        $filePath = public_path('sample_data/diamond_prodcut_sample.csv');
    
        // Check if file exists
        if (!file_exists($filePath)) {
            return back()->with('error', 'Sample CSV file not found.');
        }
    
        // Return the file as a download
        return Response::download($filePath, 'diamond_sample.csv', [
            'Content-Type' => 'text/csv',
        ]);
    }
    public function deleteAll(Request $request)
    {
        // Get user_id from request
        $userId = $request->input('user_id');
    
        // Delete all diamonds for this user
        DiamondProduct::where('user_id', $userId)->delete();
    
        return back()->with('success', 'All diamonds deleted successfully!');
    }


}