<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        .pagination {
            margin-top: 20px;
            text-align: center;
        }
        .pagination a {
            margin: 0 5px;
            text-decoration: none;
            padding: 5px 10px;
            border: 1px solid #ccc;
        }
        .pagination a.active {
            background-color: #007bff;
            color: white;
        }
    </style>
</head>
<body>
    <h1>Information</h1>
    <table>
        <thead>
            <tr>
                <th>Diamond ID</th>
                <th>Weight</th>
                <th>Color</th>
                <th>Cut</th>
                <th>Price</th>
                
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $diamonds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $diamond): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($diamond->diamond_id); ?></td>
                    <td><?php echo e($diamond->weight); ?></td>
                    <td><?php echo e($diamond->color); ?></td>
                    <td><?php echo e($diamond->cut); ?></td>
                    <td><?php echo e($diamond->cash_price); ?></td>
                    
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <!-- Pagination Links -->
    <div class="pagination">
        <?php echo e($diamonds->links()); ?> <!-- Laravel Pagination Links -->
    </div>

</body>
</html>
<?php /**PATH /home/braintreeeasysof/public_html/braintree_products_app/resources/views/product_list.blade.php ENDPATH**/ ?>