<?php

namespace App\Http\Controllers;



use Illuminate\Http\Request;

use App\Models\User;

use Illuminate\Support\Facades\View;

use App\Models\Diamond;
use App\Models\UserPage;
use App\Models\Shopify_theme_changes;



class PageController extends Controller

{
    
    public function createPage(Request $request)
    {
       
     $userId = $request->user_id; 
     $retaillerid = $request->retaillerid; 
     $text_color = $request->text_color; 
     $text_link = $request->text_link; 
     $button_background = $request->button_background; 
     $button_text_color = $request->button_text_color; 
     $button_background_hover = $request->button_background_hover; 
     $button_hover_color = $request->button_hover_color; 


     $user = User::find($userId);

     $bodyHtml = View::make('diamond-page')->render();
     $bodyHtml2 = View::make('diamond-detalis')->render();
          $data = [ 'page' => [
        
                        'title' => 'Diamond Product',
                        'body_html' => $bodyHtml,
                         ]
                 ];
          $data2 = [ 'page' => [
    
                    'title' => 'Diamond Details',
                    'body_html' => $bodyHtml2,
                     ]
             ];
            $userPage_uid = UserPage::where('user_id', $userId)->first();
            //mnue
            //  $menuData = [
            //     'menu' => [
            //         'title' => 'Main Menu',
            //         'links' => [
            //             [
            //                 'title' => 'Diamond Product',
            //                 'url' => '/pages/diamond-product',
            //                 'position' => 3,
            //             ]
            //         ]
            //     ]
            // ];
            //  $response = $user->api()->rest('POST', '/admin/api/2024-01/menus.json', $menuData);
            // dd($userPage_uid->diamond_Detalis_id);
            if(empty($userPage_uid)){
                 $response = $user->api()->rest('POST', '/admin/api/2024-01/pages.json', $data);
                 $response2 = $user->api()->rest('POST', '/admin/api/2024-01/pages.json',  $data2);
                 //  dd($response['body']['container']['page']['id']);
                if($response['body']['container']['page']['id'] && $response2['body']['container']['page']['id']) {
                  
                    $pageId = $response['body']['container']['page']['id'];
                    $pageId2 = $response2['body']['container']['page']['id'];
            
                    UserPage::create([
                        'user_id' => $userId,
                        'page_id' => $pageId,  // Save the Shopify page ID
                        'diamond_Detalis_id' => $pageId2,
                    ]);

                
     
                    Shopify_theme_changes::create([
                        'user_id' => $userId,
                        'retaillerid' => $retaillerid,
                        'text_color' => $text_color,
                        'text_link' => $text_link,
                        'button_background' => $button_background,  
                        'button_text_color' => $button_text_color,  
                        'button_background_hover' => $button_background_hover, 
                        'button_hover_color' => $button_hover_color,
                    ]);
            
                    // Return a success response
                    return response()->json('Page created successfully.');
                } else {
                    return response()->json([
                        'error' => 'Failed to create page.',
                        'details' => $response,
                    ], 400);
                }
               }else{

                   $response = $user->api()->rest('PUT', "/admin/api/2024-01/pages/".$userPage_uid->page_id.".json", $data);
                   $response2 = $user->api()->rest('PUT', "/admin/api/2024-01/pages/".$userPage_uid->diamond_Detalis_id.".json", $data2);

                   Shopify_theme_changes::where('user_id', $userId)
                   ->update([
                    'retaillerid' => $retaillerid, 
                    'text_color' => $text_color, 
                    'text_link' => $text_link,
                    'button_background' => $button_background,  
                    'button_text_color' => $button_text_color,  
                    'button_background_hover' => $button_background_hover, 
                    'button_hover_color' => $button_hover_color,
                    ]);
               
                    return response()->json('Page Update successfully.');
               }     
        
    }

    public function shopify_theme_changes(Request $request)
    {
       
        $shop_name = $request->shop_name; 

        $user_id = User::where('name', $shop_name)->value('id');
        $data = Shopify_theme_changes::where('user_id', $user_id)->first();
        
        return response()->json([
            'success' => true,
            'data' => $data,
        ]);
        
    }


    public function deletePage(Request $request)
    {
        //dd($request);
        $userId = $request->user_id;
        $user = User::find($userId);
    
        // Fetch the user's page data from the database
        $userPage = UserPage::where('user_id', $userId)->first();
    
        // Check if the page data exists for the user
        if ($userPage) {
            // Delete the diamond product page
            $response = $user->api()->rest('DELETE', "/admin/api/2024-01/pages/{$userPage->page_id}.json");
    
            // Check for the success of the first page deletion
            if ($response['status'] == 200) {
                // If the diamond details page exists, delete it too
                if ($userPage->diamond_Detalis_id) {
                    $response2 = $user->api()->rest('DELETE', "/admin/api/2024-01/pages/{$userPage->diamond_Detalis_id}.json");
    
                    if ($response2['status'] == 200) {
                        // Optionally, remove the reference in your local database
                        $userPage->delete();
    
                        return response()->json('Pages deleted successfully.');
                    } else {
                        return response()->json([
                            'error' => 'Failed to delete diamond details page.',
                            'details' => $response2,
                        ], 400);
                    }
                } else {
                    return response()->json('Diamond details page does not exist.', 400);
                }
            } else {
                return response()->json([
                    'error' => 'Failed to delete diamond product page.',
                    'details' => $response,
                ], 400);
            }
        } else {
            return response()->json('No pages found for this user.', 404);
        }
    }


    public function getDiamonds()
    {
        // die('hello');
        $diamonds = Diamond::paginate(20);
        // $diamonds = Diamond::all(); // Fetch all diamonds
        // return response()->json($diamonds); // Return data as JSON

        return response()->json($diamonds)
        ->header('Access-Control-Allow-Origin', '*') // Allow any origin
        ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
        ->header('Access-Control-Allow-Headers', 'Content-Type, X-Auth-Token, Authorization, Origin');
    }

}



