@extends('shopify-app::layouts.default')

@section('content')

    <!-- You are: (shop domain name) -->
    <p>You are: {{ $shopDomain ?? Auth::user()->name }}</p>
    
     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <h1>Amipi Products Page</h1>

    @foreach ($data as $item)
        <div class="d-flex">
            <div class="color-theme">
                <label for="retaillerid">Retailler Id:</label>
                <input type="text" name="retaillerid" id="retaillerid" placeholder="Retailer ID" value="{{ isset($item->retaillerid) ? $item->retaillerid : '' }}" />
            </div>
            

            <div class="color-theme">
                <label for="text_color">Text Color:</label>
                <input 
                    type="color" 
                    id="text_color" 
                    name="text_color" 
                    value="{{ isset($item->text_color) ? $item->text_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="text_color_text" 
                    name="text_color" 
                    value="{{ isset($item->text_color) ? $item->text_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="text_link">Text Link:</label>
                <input 
                    type="color" 
                    id="text_link" 
                    name="text_link" 
                    value="{{ isset($item->text_link) ? $item->text_link : '#0000ff' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="text_link_text" 
                    name="text_link" 
                    value="{{ isset($item->text_link) ? $item->text_link : '#0000ff' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_background">Button Background:</label>
                <input 
                    type="color" 
                    id="button_background" 
                    name="button_background" 
                    value="{{ isset($item->button_background) ? $item->button_background : '#ff0000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_background_text" 
                    name="button_background" 
                    value="{{ isset($item->button_background) ? $item->button_background : '#ff0000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_text_color">Button Text Color:</label>
                <input 
                    type="color" 
                    id="button_text_color" 
                    name="button_text_color" 
                    value="{{ isset($item->button_text_color) ? $item->button_text_color : '#ffffff' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_text_color_text" 
                    name="button_text_color" 
                    value="{{ isset($item->button_text_color) ? $item->button_text_color : '#ffffff' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_background_hover">Button Background Hover:</label>
                <input 
                    type="color" 
                    id="button_background_hover" 
                    name="button_background_hover" 
                    value="{{ isset($item->button_background_hover) ? $item->button_background_hover : '#cccccc' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_background_hover_text" 
                    name="button_background_hover" 
                    value="{{ isset($item->button_background_hover) ? $item->button_background_hover : '#cccccc' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_hover_color">Button Hover Color:</label>
                <input 
                    type="color" 
                    id="button_hover_color" 
                    name="button_hover_color" 
                    value="{{ isset($item->button_hover_color) ? $item->button_hover_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_hover_color_text" 
                    name="button_hover_color" 
                    value="{{ isset($item->button_hover_color) ? $item->button_hover_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

        </div>
        
    @endforeach

    <button id="create-page-btn">Create product list Page</button>
    
    <button id="delete-page-btn">Delete product list Pages</button>
    
    <div id="response"></div>
    
    <script>
        function syncInputs(input) {
            const inputId = input.id; // Get the ID of the input that triggered the event
            const value = input.value; // Get the value of the input
            const isColorInput = input.type === 'color'; // Check if it's a color input
            const targetId = isColorInput 
                ? inputId + "_text" // For color input, target the corresponding text input
                : inputId.replace("_text", ""); // For text input, target the corresponding color input
            
            // Validate the input value
            const isValidColor = /^#[0-9A-F]{6}$/i.test(value) || /^#[0-9A-F]{3}$/i.test(value);
            if (!isValidColor) {
                alert("Please enter a valid color code!");
                return;
            }

            // Update the corresponding input
            const targetInput = document.getElementById(targetId);
            if (targetInput) {
                targetInput.value = value;
            } else {
                console.error(`Input with id "${targetId}" not found.`);
            }
        }


    </script>
    <script>
       var userId = "{{ Auth::user()->id }}";
       $(document).ready(function() {
           $('#create-page-btn').click(function() {
               var retaillerid = $('#retaillerid').val();

               var text_color = $('#text_color').val();
               var text_link = $('#text_link').val();
               var button_background = $('#button_background').val();
               var button_text_color = $('#button_text_color').val();
               var button_background_hover = $('#button_background_hover').val();
               var button_hover_color = $('#button_hover_color').val();

 
               // Create the data object, including the user ID
                var data = {
                    user_id: userId,
                    retaillerid:retaillerid,
                    text_color: text_color,
                    text_link: text_link,
                    button_background: button_background,
                    button_text_color: button_text_color,
                    button_background_hover: button_background_hover,
                    button_hover_color: button_hover_color,
                };
    
                $.ajax({
                    url: '{{ route('create-page') }}',  // URL for the controller method
                    type: 'POST',
                    data: data,  // Send the data as part of the request
                    success: function(response) {
                        $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');
                    },
                    error: function(xhr) {
                        $('#response').html('<pre>' + xhr.responseText + '</pre>');
                    }
                });

            });
        });
        
         // Delete Page Button Click Event
        $('#delete-page-btn').click(function() {
            var data = { user_id: userId };

            $.ajax({
                // url: '{{ route('create-page') }}',
                url: '{{ route('deletepr-page') }}',  // Route for the delete-page method
                type: 'POST',
                data: data,
                success: function(response) {
                    $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');
                },
                error: function(xhr) {
                    $('#response').html('<pre>' + xhr.responseText + '</pre>');
                }
            });
        });
    // });

    </script>
  
    
@endsection

@section('scripts')
    @parent

    <script>
        actions.TitleBar.create(app, { title: 'Welcome' });
    </script>
@endsection