<?php



namespace App\Mail;



use Illuminate\Mail\Mailable;

use Illuminate\Queue\SerializesModels;



class ShortlistMail extends Mailable

{

    use SerializesModels;



    public $your_name;

    public $your_email;

    public $friend_name;

    public $friend_email;

    public $personal_message;

    public $stock_number;

    public $current_url;
	
	public $diamond_record;



    /**

     * Create a new message instance.

     *

     * @param  array  $data

     * @return void

     */

    public function __construct($data,$diamond_record)

    {

        // Directly assign sanitized values to the class properties

        $this->your_name = htmlspecialchars($data['your_name']);

        $this->your_email = filter_var($data['your_email'], FILTER_SANITIZE_EMAIL);

        $this->friend_name = htmlspecialchars($data['friend_name']);

        $this->friend_email = filter_var($data['friend_email'], FILTER_SANITIZE_EMAIL);

        $this->personal_message = htmlspecialchars($data['personal_message']);

        $this->stock_number = htmlspecialchars($data['stock_number']);

        $this->current_url = filter_var($data['current_url'], FILTER_SANITIZE_URL);
		
		$this->diamond_record = $diamond_record;

    }



    /**

     * Build the message.

     *

     * @return $this

     */

    public function build()

    {

        

         return $this->from($this->your_email, $this->your_name) // Set the sender email and name

					->replyTo($this->your_email, $this->your_name)
					
                    ->subject('Someone has shared some Diamond information with you')

                    ->cc($this->your_email, $this->your_name)

                    ->view('emails.shortlist');

    }

}

