@extends('shopify-app::layouts.default')



@section('content')



    <!-- You are: (shop domain name) -->

    <p>You are: {{ $shopDomain ?? Auth::user()->name }}</p>

    

     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



    <h1>Products Page</h1>
    <div class="d-flex">
            <div class="color-theme retailer-id">
                <label for="retaillerid">Retailler Id:</label>
                <input type="text" name="retaillerid" id="retaillerid" placeholder="Retailer ID" value="{{ isset($item->retaillerid) ? $item->retaillerid : '' }}" />
            </div>
            
            <div class="color-theme">
                <label for="body_color">Body:</label>
                <input 
                    type="color" 
                    id="body_color" 
                    name="body_color" 
                    value="{{ isset($item->body_color) ? $item->body_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="body_color_text" 
                    name="body_color" 
                    value="{{ isset($item->body_color) ? $item->body_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="heading_color">Heading Color:</label>
                <input 
                    type="color" 
                    id="heading_color" 
                    name="heading_color" 
                    value="{{ isset($item->heading_color) ? $item->heading_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="heading_color_text" 
                    name="heading_color" 
                    value="{{ isset($item->heading_color) ? $item->heading_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>
            <div class="color-theme">
                <label for="heading_font_size">Heading Font Size:</label>
                <input 
                    type="text" 
                    id="heading_font_size" 
                    name="heading_font_size" 
                    value="{{ isset($item->heading_font_size) ? $item->heading_font_size : '#000000' }}"> 
            </div>

            <div class="color-theme">
                <label for="sub_heading_font_size">Sub Heading Font Size:</label>
                <input 
                    type="text" 
                    id="sub_heading_font_size" 
                    name="sub_heading_font_size" 
                    value="{{ isset($item->sub_heading_font_size) ? $item->sub_heading_font_size : '#000000' }}"> 
            </div>

            <div class="color-theme">
                <label for="filter_font_size">Filter Title Font Size:</label>
                <input 
                    type="text" 
                    id="filter_font_size" 
                    name="filter_font_size" 
                    value="{{ isset($item->filter_font_size) ? $item->filter_font_size : '#000000' }}"> 
            </div>

            <div class="color-theme">
                <label for="primary_font_size">Primary Font Size:</label>
                <input 
                    type="text" 
                    id="primary_font_size" 
                    name="primary_font_size" 
                    value="{{ isset($item->primary_font_size) ? $item->primary_font_size : '#000000' }}" >
            </div>

            <div class="color-theme">
                <label for="text_color">Primary Text Color:</label>
                <input 
                    type="color" 
                    id="text_color" 
                    name="text_color" 
                    value="{{ isset($item->text_color) ? $item->text_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="text_color_text" 
                    name="text_color" 
                    value="{{ isset($item->text_color) ? $item->text_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="text_color">Primary Link Color:</label>
                <input 
                    type="color" 
                    id="text_color" 
                    name="text_color" 
                    value="{{ isset($item->text_color) ? $item->text_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="text_color_text" 
                    name="text_color" 
                    value="{{ isset($item->text_color) ? $item->text_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="border_color">Border Color:</label>
                <input 
                    type="color" 
                    id="border_color" 
                    name="border_color" 
                    value="{{ isset($item->border_color) ? $item->border_color : '#0000ff' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="border_color_text" 
                    name="border_color" 
                    value="{{ isset($item->border_color) ? $item->border_color : '#0000ff' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_background">Button Background:</label>
                <input 
                    type="color" 
                    id="button_background" 
                    name="button_background" 
                    value="{{ isset($item->button_background) ? $item->button_background : '#ff0000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_background_text" 
                    name="button_background" 
                    value="{{ isset($item->button_background) ? $item->button_background : '#ff0000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_text_color">Button Color:</label>
                <input 
                    type="color" 
                    id="button_text_color" 
                    name="button_text_color" 
                    value="{{ isset($item->button_text_color) ? $item->button_text_color : '#ffffff' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_text_color_text" 
                    name="button_text_color" 
                    value="{{ isset($item->button_text_color) ? $item->button_text_color : '#ffffff' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_background_hover">Button Hover:</label>
                <input 
                    type="color" 
                    id="button_background_hover" 
                    name="button_background_hover" 
                    value="{{ isset($item->button_background_hover) ? $item->button_background_hover : '#cccccc' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_background_hover_text" 
                    name="button_background_hover" 
                    value="{{ isset($item->button_background_hover) ? $item->button_background_hover : '#cccccc' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="button_hover_color">Button Hover Color:</label>
                <input 
                    type="color" 
                    id="button_hover_color" 
                    name="button_hover_color" 
                    value="{{ isset($item->button_hover_color) ? $item->button_hover_color : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="button_hover_color_text" 
                    name="button_hover_color" 
                    value="{{ isset($item->button_hover_color) ? $item->button_hover_color : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

            <div class="color-theme">
                <label for="input_bg">Text Input Box:</label>
                <input 
                    type="color" 
                    id="input_bg" 
                    name="input_bg" 
                    value="{{ isset($item->input_bg) ? $item->input_bg : '#000000' }}" 
                    onchange="syncInputs(this);">
                <input 
                    type="text" 
                    id="input_bg_text" 
                    name="input_bg" 
                    value="{{ isset($item->input_bg) ? $item->input_bg : '#000000' }}" 
                    onchange="syncInputs(this);">
            </div>

        </div>

    <button id="create-page-btn">Create product list Page</button>

    

    <button id="delete-page-btn">Delete product list Pages</button>

    

    <div id="response"></div>
    <script>
        function syncInputs(input) {
            const inputId = input.id; // Get the ID of the input that triggered the event
            const value = input.value; // Get the value of the input
            const isColorInput = input.type === 'color'; // Check if it's a color input
            const targetId = isColorInput 
                ? inputId + "_text" // For color input, target the corresponding text input
                : inputId.replace("_text", ""); // For text input, target the corresponding color input
            
            // Validate the input value
            const isValidColor = /^#[0-9A-F]{6}$/i.test(value) || /^#[0-9A-F]{3}$/i.test(value);
            if (!isValidColor) {
                alert("Please enter a valid color code!");
                return;
            }

            // Update the corresponding input
            const targetInput = document.getElementById(targetId);
            if (targetInput) {
                targetInput.value = value;
            } else {
                console.error(`Input with id "${targetId}" not found.`);
            }
        }


    </script>
    

    <script>
        var userId = "{{ Auth::user()->id }}";
       $(document).ready(function() {
           $('#create-page-btn').click(function() {
               var retaillerid = $('#retaillerid').val();

               var text_color = $('#text_color').val();
               var border_color = $('#border_color').val();
               var button_background = $('#button_background').val();
               var button_text_color = $('#button_text_color').val();
               var button_background_hover = $('#button_background_hover').val();
               var button_hover_color = $('#button_hover_color').val();
               var input_bg = $('#input_bg').val();
               var body_color = $('#body_color').val();
               var heading_color = $('#heading_color').val();
               var heading_font_size = $('#heading_font_size').val();
               var primary_font_size = $('#primary_font_size').val();
               var filter_font_size = $('#filter_font_size').val();
               var sub_heading_font_size = $('#sub_heading_font_size').val();

 
               // Create the data object, including the user ID
                var data = {
                    user_id: userId,
                    retaillerid:retaillerid,
                    text_color: text_color,
                    border_color: border_color,
                    button_background: button_background,
                    button_text_color: button_text_color,
                    button_background_hover: button_background_hover,
                    button_hover_color: button_hover_color,
                    input_bg: input_bg,
                    body_color: body_color,
                    heading_color: heading_color,
                    heading_font_size: heading_font_size,
                    primary_font_size: primary_font_size,
                    filter_font_size: filter_font_size,
                    sub_heading_font_size: sub_heading_font_size,
                };
    
                $.ajax({
                    url: '{{ route('create-page') }}',  // URL for the controller method
                    type: 'POST',
                    data: data,  // Send the data as part of the request
                    success: function(response) {
                        $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');
                    },
                    error: function(xhr) {
                        $('#response').html('<pre>' + xhr.responseText + '</pre>');
                    }
                });

            });
        });

       var userId = "{{ Auth::user()->id }}";

        // $(document).ready(function() {

        //     $('#create-page-btn').click(function() {

        //         // Create the data object, including the user ID

        //         var data = {

        //             user_id: userId

        //         };

    

        //         $.ajax({

        //             url: '{{ route('create-page') }}',  // URL for the controller method

        //             type: 'POST',

        //             data: data,  // Send the data as part of the request

        //             success: function(response) {

        //                 $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');

        //             },

        //             error: function(xhr) {

        //                 $('#response').html('<pre>' + xhr.responseText + '</pre>');

        //             }

        //         });

        //     });

        // });

        

         // Delete Page Button Click Event

        $('#delete-page-btn').click(function() {

            var data = { user_id: userId };



            $.ajax({

                // url: '{{ route('create-page') }}',

                url: '{{ route('deletepr-page') }}',  // Route for the delete-page method

                type: 'POST',

                data: data,

                success: function(response) {

                    $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');

                },

                error: function(xhr) {

                    $('#response').html('<pre>' + xhr.responseText + '</pre>');

                }

            });

        });

    // });

    

    </script>

    

    

@endsection



@section('scripts')

    @parent



    <script>

        actions.TitleBar.create(app, { title: 'Welcome' });

    </script>

@endsection