@extends('shopify-app::layouts.default')

@section('content')

    <!-- You are: (shop domain name) -->
    <p>You are: {{ $shopDomain ?? Auth::user()->name }}</p>
    
     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <h1>Amipi Products Page</h1>
    <button id="create-page-btn">Create product list Page</button>
    
    <button id="delete-page-btn">Delete product list Pages</button>
    
    <div id="response"></div>
    
    <script>
       var userId = "{{ Auth::user()->id }}";
        $(document).ready(function() {
            $('#create-page-btn').click(function() {
                // Create the data object, including the user ID
                var data = {
                    user_id: userId
                };
    
                $.ajax({
                    url: '{{ route('create-page') }}',  // URL for the controller method
                    type: 'POST',
                    data: data,  // Send the data as part of the request
                    success: function(response) {
                        $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');
                    },
                    error: function(xhr) {
                        $('#response').html('<pre>' + xhr.responseText + '</pre>');
                    }
                });
            });
        });
        
         // Delete Page Button Click Event
        $('#delete-page-btn').click(function() {
            var data = { user_id: userId };

            $.ajax({
                // url: '{{ route('create-page') }}',
                url: '{{ route('deletepr-page') }}',  // Route for the delete-page method
                type: 'POST',
                data: data,
                success: function(response) {
                    $('#response').html('<pre>' + JSON.stringify(response, null, 2) + '</pre>');
                },
                error: function(xhr) {
                    $('#response').html('<pre>' + xhr.responseText + '</pre>');
                }
            });
        });
    // });
    
    </script>
    
    
@endsection

@section('scripts')
    @parent

    <script>
        actions.TitleBar.create(app, { title: 'Welcome' });
    </script>
@endsection