<?php

namespace App\Jobs;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Log;

class ShopRedactJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $shopDomain;
    public $data;

    public function __construct($shopDomain, $data)
    {
        $this->shopDomain = $shopDomain;
        $this->data = $data;
    }

    public function handle()
    {
        try {
            // Find and delete the shop user
            $shop = User::where('name', $this->shopDomain)->first();
            if ($shop) {
                $shop->delete();
            }
            Log::info("Shop redact completed for shop domain: {$this->shopDomain}");
        } catch (\Exception $e) {
            Log::error("Error handling shop redact: {$e->getMessage()}");
        }
    }
}
