<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PageController; 
use App\Http\Controllers\DiamondController;
use App\Shopify_theme_changes;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
     
//     $userId = Auth::user()->id;
//     $data = Shopify_theme_changes::where('user_id', $userId)->get();
//     return view('welcome', compact('data'));
// })->middleware(['verify.shopify', 'online.store.required'])->name('home');


Route::get('/', function () {
   
    $userId = Auth::user()->id;
    $data = Shopify_theme_changes::where('user_id', $userId)->get();
    $user = Auth::user();
    $shopInfoResponse = $user->api()->rest('GET', '/admin/api/2024-01/shop.json');
    $shopInfo = $shopInfoResponse['body']['shop'] ?? null;

    // Fetch Themes
    $themesResponse = $user->api()->rest('GET', '/admin/api/2024-01/themes.json');
    $themes = $themesResponse['body']['themes'] ?? null;

    // Get Current Theme
    $currentTheme = collect($themes)->firstWhere('role', 'main'); 
    if (!$shopInfo || !$currentTheme) {
        return response()->json([
            'error' => 'Failed to fetch shop info or themes.',
        ]);
    }

    $storeName = explode('.', $shopInfo['myshopify_domain'])[0]; 
    $themeId = $currentTheme['id'];
    $themeEditorUrl = "https://admin.shopify.com/store/{$storeName}/themes/{$themeId}/editor?context=apps";

    // Fetch settings_data.json
    $settingsResponse = $user->api()->rest('GET', "/admin/api/2024-01/themes/{$themeId}/assets.json", [
        'asset[key]' => 'config/settings_data.json',
    ]);

    $blocks = [];
    if ($settingsResponse['status'] === 200) {
          $settingsData = json_decode($settingsResponse['body']['asset']['value'] ?? '{}', true);
       
        if (isset($settingsData['current']['blocks'])) {
               
           foreach ($settingsData['current']['blocks'] as $blockId => $block) {
            
               if (isset($block['type']) && str_contains($block['type'], 'shopify://apps/amipi-diamond-new/blocks/app-embed')) {
                    $status =$block['disabled'] ;
                    // dd($status);
                }
            }
        }
    }
   
    return view('welcome',[
        'store' => $shopInfo,
        'storeName' => $shopInfo['name'] ?? 'Unknown Store',
        'currentTheme' => $currentTheme,
        'themeEditorUrl' => $themeEditorUrl,
        'status' => $status ?? '',
        'host' => $shopInfo['domain'],
        'data'=> $data
        ] );
})->middleware(['verify.shopify'])->name('home');
Route::get('/error', function () {
    $message = session('message') ?? 'An error occurred.';
    return view('error', compact('message'));
})->name('error');

 Route::post('/create-page', [PageController::class, 'createPage'])->name('create-page');
 Route::post('/shopify-theme-changes', [PageController::class, 'shopify_theme_changes'])->name('shopify-theme-changes');

// Route::middleware('verify.shopify')->group(function () {
//     Route::post('/create-page', [PageController::class, 'createPage'])->name('create-page');
// });

Route::get('/diamonds', [PageController::class, 'getDiamonds'])->name('diamonds.get');

Route::get('/load-more-diamond', [DiamondController::class,'load_more_data'])->name('load_more_data');
Route::get('/diamond-details', [DiamondController::class,'diamond_details'])->name('diamond_details');
Route::get('/add-to-cart', [DiamondController::class,'add_to_cart'])->name('add_to_cart');
Route::get('/addToCart', [DiamondController::class,'addToCart'])->name('addToCart');

// Route::get('/load-more-diamond', [DiamondController::class,'load_more_data'])->middleware('cors');

// Route::get('load_more_data', [YourController::class, 'load_more_data'])->middleware('cors');

Route::post('/deletepr-page', [PageController::class, 'deletePage'])->name('deletepr-page');

use App\Http\Controllers\ShopifyWebhookController;
Route::post('/shop-redact',[ShopifyWebhookController::class,'handleShopRedact'])->middleware('auth.webhook')->name('shop.redact');
// Route::post('/webhook/shop-redact', [ShopifyWebhookController::class, 'handleShopRedact']);
Route::post('/webhook/customers-redact', [ShopifyWebhookController::class, 'handleCustomersRedact']);
Route::post('/webhook/customers-data-request', [ShopifyWebhookController::class, 'handleCustomersDataRequest']);


Route::get('/log', function () {
    \Log::info('Test log message');
});

Route::get('/diamond', function () {
    return view('diamond-page');
});
Route::get('/diamond-detail', function () {
    return view('diamond-detalis');
});

Route::get('/getProductPublications', [DiamondController::class,'getProductPublications'])->name('getProductPublications');

Route::get('/getSalesChannelIds', [DiamondController::class,'getSalesChannelIds'])->name('getSalesChannelIds');

