<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="shopify-api-key" content="<?php echo e(env('SHOPIFY_API_KEY')); ?>">
    <title><?php echo e(config('app.name', 'Laravel Shopify App')); ?></title>

    <!-- App Bridge v3 -->
       <script src="https://cdn.shopify.com/shopifycloud/app-bridge.js"></script>
    <script src="https://unpkg.com/@shopify/app-bridge@3"></script>
    <script src="https://unpkg.com/@shopify/app-bridge@3.7.10/umd/index.js"></script>
</head>
<body>
    <main role="main">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

<script>
    const AppBridge = window['app-bridge'];
    const createApp = AppBridge.default;
    const Redirect = AppBridge.actions.Redirect;

    const app = createApp({
        apiKey: '<?php echo e(config('shopify-app.api_key')); ?>',
        host: '<?php echo e(request()->get("host")); ?>',
        forceRedirect: true
    });
    // console.log(app);
   
</script>

</body>
</html><?php /**PATH /home/amipiinc/diamondapp.mydiamondsearch.com/pub_diamond_products/vendor/kyon147/laravel-shopify/src/resources/views/layouts/app.blade.php ENDPATH**/ ?>