<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PageController;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\AppEmbedController;

use App\Http\Controllers\DiamondController;
use App\Models\UserPage;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/privacy-diamond', function () {
    return view('privacy-diamond');
});
Route::get('/userguide', function () {
    return view('userguide');
});

// Route::get('/', function () {
//     $user = Auth::user();
//     $shopInfoResponse = $user->api()->rest('GET', '/admin/api/2024-01/shop.json');
//     $shopInfo = $shopInfoResponse['body']['shop'] ?? null;
//     $themesResponse = $user->api()->rest('GET', '/admin/api/2024-01/themes.json');
//     $themes = $themesResponse['body']['themes'] ?? null;

//     $currentTheme = collect($themes)->firstWhere('role', 'main'); 
//     if (!$shopInfo || !$currentTheme) {
//         return response()->json([
//             'error' => 'Failed to fetch shop info or themes.',
//         ]);
//     }

//     $storeName = explode('.', $shopInfo['myshopify_domain'])[0]; 
//     $themeId = $currentTheme['id'];
//     $themeEditorUrl = "https://admin.shopify.com/store/{$storeName}/themes/{$themeId}/editor?context=apps";

//     return view('welcome', [
//         'storeName' => $shopInfo['name'] ?? 'Unknown Store',
//         'currentTheme' => $currentTheme,
//         'themeEditorUrl' => $themeEditorUrl,
//     ]);
// })->middleware(['verify.shopify'])->name('home');

Route::get('/', function () {
    $user = Auth::user();
    // Fetch Shop Info
    $shopInfoResponse = $user->api()->rest('GET', '/admin/api/2024-01/shop.json');
    $shopInfo = $shopInfoResponse['body']['shop'] ?? null;

    // Fetch Themes
    $themesResponse = $user->api()->rest('GET', '/admin/api/2024-01/themes.json');
    $themes = $themesResponse['body']['themes'] ?? null;

    // Get Current Theme
    $currentTheme = collect($themes)->firstWhere('role', 'main'); 
    if (!$shopInfo || !$currentTheme) {
        return response()->json([
            'error' => 'Failed to fetch shop info or themes.',
        ]);
    }

    $storeName = explode('.', $shopInfo['myshopify_domain'])[0]; 
    $themeId = $currentTheme['id'];
    $themeEditorUrl = "https://admin.shopify.com/store/{$storeName}/themes/{$themeId}/editor?context=apps";

    // Fetch settings_data.json
    $settingsResponse = $user->api()->rest('GET', "/admin/api/2024-01/themes/{$themeId}/assets.json", [
        'asset[key]' => 'config/settings_data.json',
    ]);
//dd($settingsResponse);
    $blocks = [];
    if ($settingsResponse['status'] === 200) {
        $settingsData = json_decode($settingsResponse['body']['asset']['value'] ?? '{}', true);
        if (isset($settingsData['current']['blocks'])) {
           foreach ($settingsData['current']['blocks'] as $blockId => $block) {
               if (isset($block['type']) && str_contains($block['type'], 'shopify://apps/braintree-products-app/blocks/app_embed')) {
                    $status =$block['disabled'] ;
                   
                }
            }
        }
    }

    // Pass data to the view
    return view('welcome', [
        'storeName' => $shopInfo['name'] ?? 'Unknown Store',
        'currentTheme' => $currentTheme,
        'themeEditorUrl' => $themeEditorUrl,
        'status' => isset($status) ? $status : '',
    ]);
})->middleware(['verify.shopify'])->name('home');

// Route::middleware(['verify.shopify','billable'])->group(function () {
//     Route::get('/', function () {
//         $user = Auth::user();
//         // Fetch Shop Info
//         $shopInfoResponse = $user->api()->rest('GET', '/admin/api/2024-01/shop.json');
//         $shopInfo = $shopInfoResponse['body']['shop'] ?? null;
    
//         // Fetch Themes
//         $themesResponse = $user->api()->rest('GET', '/admin/api/2024-01/themes.json');
//         $themes = $themesResponse['body']['themes'] ?? null;
    
//         // Get Current Theme
//         $currentTheme = collect($themes)->firstWhere('role', 'main'); 
//         if (!$shopInfo || !$currentTheme) {
//             return response()->json([
//                 'error' => 'Failed to fetch shop info or themes.',
//             ]);
//         }
    
//         $storeName = explode('.', $shopInfo['myshopify_domain'])[0]; 
//         $themeId = $currentTheme['id'];
//         $themeEditorUrl = "https://admin.shopify.com/store/{$storeName}/themes/{$themeId}/editor?context=apps";
    
//         // Fetch settings_data.json
//         $settingsResponse = $user->api()->rest('GET', "/admin/api/2024-01/themes/{$themeId}/assets.json", [
//             'asset[key]' => 'config/settings_data.json',
//         ]);
//     //dd($settingsResponse);
//         $blocks = [];
//         if ($settingsResponse['status'] === 200) {
//             $settingsData = json_decode($settingsResponse['body']['asset']['value'] ?? '{}', true);
//             if (isset($settingsData['current']['blocks'])) {
//                foreach ($settingsData['current']['blocks'] as $blockId => $block) {
//                    if (isset($block['type']) && str_contains($block['type'], 'shopify://apps/braintree-products-app/blocks/app_embed')) {
//                         $status =$block['disabled'] ;
                       
//                     }
//                 }
//             }
//         }
    
//         // Pass data to the view
//         return view('welcome', [
//             'storeName' => $shopInfo['name'] ?? 'Unknown Store',
//             'currentTheme' => $currentTheme,
//             'themeEditorUrl' => $themeEditorUrl,
//             'status' => $status,
//         ]);
//     })->name('home');
    
// });

Route::post('/create-page', [PageController::class, 'createPage'])->name('create-page');
Route::post('/deletepr-page', [PageController::class, 'deletePage'])->name('deletepr-page');




// Route::middleware(['verify.shopify'])->group(function () {
    Route::get('/app-embed/status', [AppEmbedController::class, 'checkEmbedStatus']);
    Route::post('/app-embed/enable', [AppEmbedController::class, 'enableEmbed']);
    Route::post('/app-embed/disable', [AppEmbedController::class, 'disableEmbed']);
// });


Route::get('/get-pr', function (Request $request) {
    return response()->json(['csrf_token' => csrf_token()])
        ->header('Access-Control-Allow-Origin', '*') 
        ->header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
        ->header('Access-Control-Allow-Headers', 'Content-Type, X-Auth-Token, Authorization, Origin');
});

Route::get('/load-more-diamond', [DiamondController::class,'load_more_data'])->name('load_more_data');
Route::get('/diamond-details', [DiamondController::class,'diamond_details'])->name('diamond_details');
Route::get('/add-to-cart', [DiamondController::class,'add_to_cart'])->name('add_to_cart');
// Route::get('/addToCart', [DiamondController::class,'addToCart'])->name('addToCart');

Route::get('/test-csrf', function () {
    return response()->json(['message' => 'CSRF Test'])->header('XSRF-TOKEN', csrf_token());
});

Route::get('/pricing', [PageController::class, 'PricingPlan'])->name('pricing');
