<div class="container mt-5">
    <h1 class="text-center mb-4">Pricing Plans</h1>
    <div class="row">
        @if($plans->isEmpty())
            <div class="col-12">
                <p class="text-center">No plans are available at the moment. Please check back later.</p>
            </div>
        @else
            @foreach($plans as $plan)
                <div class="col-md-4 mb-4">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title">{{ $plan->name }}</h5>
                            <p class="card-text">
                                <strong>Type:</strong> {{ ucfirst($plan->type) }} <br>
                                <strong>Price:</strong> ₹{{ number_format($plan->price, 2) }} <br>
                                <strong>Interval:</strong> {{ ucfirst($plan->interval) }} <br>
                                <strong>Trial Days:</strong> {{ $plan->trial_days }} Days <br>
                                @if($plan->capped_amount)
                                    <strong>Capped Amount:</strong> ₹{{ number_format($plan->capped_amount, 2) }} <br>
                                @endif
                                @if($plan->terms)
                                    <strong>Terms:</strong> {{ $plan->terms }} <br>
                                @endif
                            </p>
                            @if($plan->on_install)
                                <p class="badge bg-success">Applied on Install</p>
                            @endif
                            @if($plan->test)
                                <p class="badge bg-warning">Test Plan</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>
</div>