<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\AppEmbed;

class AppEmbedController extends Controller
{
    public function checkEmbedStatus()
    {
        $user = Auth::user();
        $shopDomain = $user->name; // Shopify store domain (e.g., 'example.myshopify.com')

        $appEmbed = AppEmbed::where('shop_domain', $shopDomain)->first();

        return response()->json([
            'is_enabled' => $appEmbed ? $appEmbed->is_enabled : false,
        ]);
    }

    public function enableEmbed(Request $request)
    {
        $user = Auth::user();
        $shopDomain = $user->name; // Shopify store domain

        $appEmbed = AppEmbed::updateOrCreate(
            ['shop_domain' => $shopDomain],
            ['is_enabled' => true]
        );

        return response()->json([
            'message' => 'App embed enabled successfully.',
            'is_enabled' => $appEmbed->is_enabled,
        ])
        ->json(['status' => 'success', 'message' => 'App embed enabled successfully'])
        ->header('Access-Control-Allow-Origin', '*')
        ->header('Access-Control-Allow-Methods', 'POST')
        ->header('Access-Control-Allow-Headers', 'Content-Type, X-CSRF-TOKEN');
        
    }

    public function disableEmbed(Request $request)
    {
        $user = Auth::user();
        $shopDomain = $user->name; // Shopify store domain

        $appEmbed = AppEmbed::updateOrCreate(
            ['shop_domain' => $shopDomain],
            ['is_enabled' => false]
        );

        return response()->json([
            'message' => 'App embed disabled successfully.',
            'is_enabled' => $appEmbed->is_enabled,
        ]);
    }
}
