<div class="container mt-5">
    <h1 class="text-center mb-4">Pricing Plans</h1>
    <div class="row">
        <?php if($plans->isEmpty()): ?>
            <div class="col-12">
                <p class="text-center">No plans are available at the moment. Please check back later.</p>
            </div>
        <?php else: ?>
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4 mb-4">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e($plan->name); ?></h5>
                            <p class="card-text">
                                <strong>Type:</strong> <?php echo e(ucfirst($plan->type)); ?> <br>
                                <strong>Price:</strong> ₹<?php echo e(number_format($plan->price, 2)); ?> <br>
                                <strong>Interval:</strong> <?php echo e(ucfirst($plan->interval)); ?> <br>
                                <strong>Trial Days:</strong> <?php echo e($plan->trial_days); ?> Days <br>
                                <?php if($plan->capped_amount): ?>
                                    <strong>Capped Amount:</strong> ₹<?php echo e(number_format($plan->capped_amount, 2)); ?> <br>
                                <?php endif; ?>
                                <?php if($plan->terms): ?>
                                    <strong>Terms:</strong> <?php echo e($plan->terms); ?> <br>
                                <?php endif; ?>
                            </p>
                            <?php if($plan->on_install): ?>
                                <p class="badge bg-success">Applied on Install</p>
                            <?php endif; ?>
                            <?php if($plan->test): ?>
                                <p class="badge bg-warning">Test Plan</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>
</div><?php /**PATH /home/braintreeeasysof/public_html/braintree_app/resources/views/plan.blade.php ENDPATH**/ ?>